/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.ConfigTestEnum;
import fi.dy.masa.malilib.test.TestDataSyncer;
import fi.dy.masa.malilib.test.TestInventoryOverlayHandler;
import fi.dy.masa.malilib.test.TestSelector;
import fi.dy.masa.malilib.test.TestWalls;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtInventory;
import fi.dy.masa.malilib.util.time.TickUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_10209;
import net.minecraft.class_11187;
import net.minecraft.class_11573;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_8887;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Experimental
public class TestRenderHandler
implements IRenderer {
    private static final TestRenderHandler INSTANCE = new TestRenderHandler();

    public static TestRenderHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void onRenderGameOverlayPostAdvanced(class_332 drawContext, float partialTicks, class_3695 profiler, class_310 mc) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            if (MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getBooleanValue() && MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind().isKeybindHeld()) {
                if (TestInventoryOverlayHandler.getInstance().isNewCode()) {
                    TestInventoryOverlayHandler.getInstance().getRenderContextNew(drawContext, profiler, mc);
                } else {
                    TestInventoryOverlayHandler.getInstance().getRenderContext(drawContext, profiler, mc);
                }
            }
            if (ConfigTestEnum.TEST_TEXT_LINES.getBooleanValue()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("Test Line 1");
                list.add("Test Line 2");
                list.add("Test Line 3");
                list.add("Test Line 4");
                list.add("Test Line 5");
                if (TickUtils.getInstance().isValid()) {
                    String result = TestRenderHandler.getMeasuredTPS();
                    list.addFirst(result);
                    list.removeLast();
                }
                RenderUtils.renderText(drawContext, 4, 4, MaLiLibConfigs.Test.TEST_CONFIG_FLOAT.getFloatValue(), -2039584, -1605349296, HudAlignment.TOP_LEFT, true, false, true, list);
            }
        }
    }

    @Nonnull
    private static String getMeasuredTPS() {
        String sprintStr;
        float tickRate = TickUtils.getTickRate();
        double clampedTps = TickUtils.getMeasuredTPS();
        double actualTps = TickUtils.getActualTPS();
        double avgMspt = TickUtils.getAvgMSPT();
        double avgTps = TickUtils.getAvgTPS();
        double mspt = TickUtils.getMeasuredMSPT();
        String rst = GuiBase.TXT_RST;
        String preTps = clampedTps >= (double)tickRate ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
        boolean isEstimated = TickUtils.isEstimated();
        boolean isSprinting = TickUtils.isSprinting();
        String string = sprintStr = isSprinting ? "- " + GuiBase.TXT_LIGHT_PURPLE + GuiBase.TXT_BOLD + "Sprinting" + rst : "";
        String preMspt = mspt <= 40.0 ? GuiBase.TXT_GREEN : (mspt <= 45.0 ? GuiBase.TXT_YELLOW : (mspt <= 50.0 ? GuiBase.TXT_GOLD : GuiBase.TXT_RED));
        return isEstimated ? String.format("Server TPS: %s%.1f%s (MSPT [est]: %s%.1f%s) (R: %s%.1f%s, avMS: %.2f, avTPS: %.2f, [actTPS: %.2f]) %s", preTps, clampedTps, rst, preMspt, mspt, rst, GuiBase.TXT_AQUA, Float.valueOf(tickRate), rst, avgMspt, avgTps, actualTps, sprintStr) : String.format("Server TPS: %s%.1f%s MSPT: %s%.1f%s (R: %s%.1f%s, avMS: %.2f, avTPS: %.2f, [actTPS: %.2f]) %s", preTps, clampedTps, rst, preMspt, mspt, rst, GuiBase.TXT_AQUA, Float.valueOf(tickRate), rst, avgMspt, avgTps, actualTps, sprintStr);
    }

    @Override
    public void onRenderWorldPostDebugRender(class_4587 matrices, class_4604 frustum, class_4597.class_4598 immediate, class_243 camera, class_3695 profiler) {
    }

    @Override
    public void onRenderWorldPreWeather(class_276 fb, Matrix4f posMatrix, Matrix4f projMatrix, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
    }

    @Override
    public void onRenderWorldLastAdvanced(class_276 fb, Matrix4f posMatrix, Matrix4f projMatrix, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null) {
                profiler.method_15396("malilib_selector");
                if (TestSelector.INSTANCE.shouldRender()) {
                    TestSelector.INSTANCE.render(posMatrix, projMatrix, profiler, mc);
                }
                profiler.method_15405("malilib_targeting_overlay");
                this.renderTargetingOverlay(posMatrix, mc);
                profiler.method_15405("malilib_test_walls");
                if (ConfigTestEnum.TEST_WALLS_HOTKEY.getBooleanValue()) {
                    if (TestWalls.INSTANCE.needsUpdate(mc.method_1560(), mc)) {
                        TestWalls.INSTANCE.update(camera, mc.method_1560(), mc);
                    }
                    TestWalls.INSTANCE.render(camera, posMatrix, projMatrix, mc, profiler);
                }
                profiler.method_15407();
            }
        }
    }

    @Override
    public void onRenderTooltipComponentInsertFirst(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.accept(StringUtils.translateAsText("malilib.gui.tooltip.test.first", new Object[0]));
        }
    }

    @Override
    public void onRenderTooltipComponentInsertMiddle(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.accept(StringUtils.translateAsText("malilib.gui.tooltip.test.middle", new Object[0]));
        }
    }

    @Override
    public void onRenderTooltipComponentInsertLast(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.accept(StringUtils.translateAsText("malilib.gui.tooltip.test.last", new Object[0]));
        }
    }

    @Override
    public void onRenderTooltipLast(class_332 drawContext, class_1799 stack, int x, int y) {
        class_1792 item = stack.method_7909();
        class_3695 profiler = class_10209.method_64146();
        if (item instanceof class_1806) {
            if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
                profiler.method_15396("malilib_map_preview");
                RenderUtils.renderMapPreview(drawContext, stack, x, y, 160, false);
                profiler.method_15407();
            }
        } else if (stack.method_57353().method_57832(class_9334.field_49622) && InventoryUtils.shulkerBoxHasItems(stack)) {
            if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
                profiler.method_15396("malilib_shulker_preview");
                RenderUtils.renderShulkerBoxPreview(drawContext, stack, x, y, true);
                profiler.method_15407();
            }
        } else if (stack.method_57353().method_57832(class_9334.field_49650) && InventoryUtils.bundleHasItems(stack)) {
            if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
                profiler.method_15396("malilib_bundle_preview");
                RenderUtils.renderBundlePreview(drawContext, stack, x, y, MaLiLibConfigs.Test.TEST_BUNDLE_PREVIEW_WIDTH.getIntegerValue(), true);
                profiler.method_15407();
            }
        } else if (stack.method_31574(class_1802.field_8466) && MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
            class_1657 pe;
            Object object;
            Pair<class_1297, class_2487> pair;
            class_1730 inv;
            class_310 mc = class_310.method_1551();
            class_1937 world = WorldUtils.getBestWorld(mc);
            if (mc.field_1724 == null || world == null) {
                return;
            }
            class_1657 player = world.method_18470(mc.field_1724.method_5667());
            if (player != null && (inv = (pair = TestDataSyncer.getInstance().requestEntity(world, player.method_5628())) != null && pair.getRight() != null && ((class_2487)pair.getRight()).method_10545("EnderItems") ? InventoryUtils.getPlayerEnderItemsFromNbt((class_2487)pair.getRight(), world.method_30349()) : (pair != null && (object = pair.getLeft()) instanceof class_1657 && !(pe = (class_1657)object).method_7274().method_5442() ? pe.method_7274() : player.method_7274())) != null) {
                try (NbtInventory nbtInv = NbtInventory.fromInventory((class_1263)inv);){
                    class_2499 list = nbtInv.toNbtList(world.method_30349());
                    class_2487 nbt = new class_2487();
                    nbt.method_10566("EnderItems", (class_2520)list);
                    RenderUtils.renderNbtItemsPreview(drawContext, stack, nbt, x, y, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Supplier<String> getProfilerSectionSupplier() {
        return () -> "malilib_test";
    }

    private void renderTargetingOverlay(Matrix4f posMatrix, class_310 mc) {
        class_1297 entity = mc.method_1560();
        if (entity != null && mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332 && MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isCtrlDown()) {
            class_3965 hitResult = (class_3965)mc.field_1765;
            Color4f color = Color4f.fromColor(StringUtils.getColor("#C03030F0", 0));
            RenderUtils.renderBlockTargetingOverlay(entity, hitResult.method_17777(), hitResult.method_17780(), hitResult.method_17784(), color, posMatrix);
        }
    }

    public static void renderInventoryOverlayOG(class_332 drawContext, InventoryOverlay.Context context, class_310 mc) {
        class_1309 entityLivingBase = null;
        class_2586 be = null;
        class_1263 inv = null;
        class_2487 nbt = new class_2487();
        if (context == null) {
            return;
        }
        if (context.be() != null) {
            be = context.be();
        } else if (context.entity() != null && context.entity() instanceof class_1309) {
            entityLivingBase = context.entity();
        }
        if (context.inv() != null) {
            inv = context.inv();
        }
        if (context.nbt() != null) {
            nbt.method_10543(context.nbt());
        }
        boolean isWolf = entityLivingBase instanceof class_1493 || entityLivingBase instanceof class_11187 || entityLivingBase instanceof class_11573;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        MaLiLib.LOGGER.error("0: -> inv.type [{}] // nbt.type [{}]", (Object)(context.inv() != null ? InventoryOverlay.getInventoryType(context.inv()) : null), context.nbt() != null ? InventoryOverlay.getInventoryType(context.nbt()) : null);
        MaLiLib.LOGGER.error("1: -> inv.size [{}] // inv.isEmpty [{}]", (Object)(context.inv() != null ? context.inv().method_5439() : -1), (Object)(context.inv() != null ? (Comparable<Boolean>)Boolean.valueOf(context.inv().method_5442()) : (Comparable<Boolean>)Integer.valueOf(-1)));
        if (inv != null && inv.method_5439() > 0) {
            class_2248 class_22482;
            boolean isHorse = entityLivingBase instanceof class_1496;
            int totalSlots = isHorse ? inv.method_5439() - 1 : inv.method_5439();
            int firstSlot = isHorse ? 1 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof class_1646 ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType(inv, nbt, context);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            HashSet<Integer> lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if (be != null && type == InventoryOverlay.InventoryRenderType.CRAFTER) {
                if (be instanceof class_8887) {
                    class_8887 cbe = (class_8887)be;
                    lockedSlots = BlockUtils.getDisabledSlots(cbe);
                } else if (context.nbt() != null) {
                    lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(context.nbt());
                }
            }
            if (context.be() != null && (class_22482 = context.be().method_11010().method_26204()) instanceof class_2480) {
                class_2480 sbb = (class_2480)class_22482;
                RenderUtils.setShulkerboxBackgroundTintColor(sbb, true);
            }
            MaLiLib.LOGGER.warn("render():0: type [{}] // Nbt Type [{}]", (Object)type.toString(), context.nbt() != null ? InventoryOverlay.getInventoryType(context.nbt()) : "INVALID");
            if (isHorse) {
                class_1277 horseInv = new class_1277(2);
                class_1799 horseArmor = ((class_1496)entityLivingBase).method_56676();
                horseInv.method_5447(0, horseArmor != null && !horseArmor.method_7960() ? horseArmor : class_1799.field_8037);
                horseInv.method_5447(1, inv.method_5438(0));
                InventoryOverlay.renderInventoryBackground(drawContext, type, xInv, yInv, 1, 2, mc);
                if (type == InventoryOverlay.InventoryRenderType.LLAMA) {
                    InventoryOverlay.renderLlamaArmorBackgroundSlots(drawContext, (class_1263)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
                } else {
                    InventoryOverlay.renderHorseArmorBackgroundSlots(drawContext, (class_1263)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
                }
                InventoryOverlay.renderInventoryStacks(drawContext, type, (class_1263)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, 2, mc);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground(drawContext, type, xInv, yInv, props.slotsPerRow, totalSlots, mc);
                if (type == InventoryOverlay.InventoryRenderType.BREWING_STAND) {
                    InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, xInv, yInv);
                }
                InventoryOverlay.renderInventoryStacks(drawContext, type, inv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, props.slotsPerRow, firstSlot, totalSlots, lockedSlots, mc);
            }
        }
        if (isWolf) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.WOLF;
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, 2);
            int rows = (int)Math.ceil(2.0 / (double)props.slotsPerRow);
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            x = xCenter - 55;
            int xInv = xCenter + 2;
            yInv = Math.min(yInv, yCenter - 92);
            class_1277 wolfInv = new class_1277(2);
            class_1799 wolfArmor = ((class_1493)entityLivingBase).method_56676();
            wolfInv.method_5447(0, wolfArmor != null && !wolfArmor.method_7960() ? wolfArmor : class_1799.field_8037);
            InventoryOverlay.renderInventoryBackground(drawContext, type, xInv, yInv, 1, 2, mc);
            InventoryOverlay.renderWolfArmorBackgroundSlots(drawContext, (class_1263)wolfInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
            InventoryOverlay.renderInventoryStacks(drawContext, type, (class_1263)wolfInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, 2, mc);
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground(drawContext, x, y, entityLivingBase);
            InventoryOverlay.renderEquipmentStacks(drawContext, entityLivingBase, x, y, mc);
        }
    }
}

