/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.RootModelType;
import java.util.List;
import java.util.function.Consumer;

public class ExportHelper {
    public static void flattenElements(List<ModelElement> elems, int[] id, List<Cube> flatList) {
        for (ModelElement me : elems) {
            if (me.templateElement) continue;
            switch (me.type) {
                case NORMAL: {
                    id[0] = id[0] + 1;
                    me.id = me.id;
                    flatList.add(me);
                    me.type.preRenderUpdate(me);
                    break;
                }
                case ROOT_PART: {
                    if (me.duplicated || me.typeData instanceof RootModelType) {
                        Cube fake = Cube.newFakeCube();
                        id[0] = id[0] + 1;
                        fake.id = me.id = me.id;
                        fake.pos = me.pos;
                        fake.rotation = me.rotation;
                        flatList.add(fake);
                        break;
                    }
                    me.id = ((RootModelElement)me.rc).getPart().getId(me.rc);
                    break;
                }
            }
            if (me.parent != null) {
                me.parentId = me.parent.id;
            }
            ExportHelper.flattenElements(me.children, id, flatList);
        }
    }

    public static void walkElements(List<ModelElement> elems, Consumer<ModelElement> c) {
        for (ModelElement me : elems) {
            c.accept(me);
            ExportHelper.walkElements(me.children, c);
        }
    }
}

