/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.math.Box;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.VBuffer;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.model.render.RenderMode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.FloatBuffer;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_8030;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Panel3dImpl
extends Panel3d.Panel3dNative {
    private class_310 mc = class_310.method_1551();
    private Vec2i mouse;
    private Mat4f view;
    private Mat4f proj;

    public Panel3dImpl(Panel3d panel) {
        super(panel);
    }

    @Override
    public void render(float partialTicks) {
        GuiImpl gui = (GuiImpl)this.panel.getGui().getNativeGui();
        Vec2i mouse = super.getMouse();
        Vec2i off = this.panel.getGui().getOffset();
        this.mouse = new Vec2i(mouse.x - off.x, mouse.y - off.y);
        Box bounds = this.getBounds();
        gui.drawPip(this, bounds.w, bounds.h, State::new);
    }

    @Override
    public Vec2i get3dSize() {
        return new Vec2i(this.panel.getBounds().w, this.panel.getBounds().h);
    }

    @Override
    public Vec2i getMouse() {
        return this.mouse;
    }

    @Override
    public void draw3dOverlay() {
        Box bounds = this.getBounds();
        Vec2i ws = this.get3dSize();
        this.panel.getGui().drawTexture(bounds.x, bounds.y, bounds.w, bounds.h, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes() {
        return this.getRenderTypes0(MinecraftObject.DynTexture.getBoundLoc());
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes(String texture) {
        return this.getRenderTypes0(class_2960.method_43902((String)"cpm", (String)("textures/gui/" + texture + ".png")));
    }

    @Override
    public Image takeScreenshot(Vec2i size) {
        GuiImpl gui = (GuiImpl)this.panel.getGui().getNativeGui();
        int dw = this.mc.method_22683().method_4489();
        int dh = this.mc.method_22683().method_4506();
        float multiplierX = (float)dw / (float)gui.field_22789;
        float multiplierY = (float)dh / (float)gui.field_22790;
        int width = (int)(multiplierX * (float)size.x);
        int height = (int)(multiplierY * (float)size.y);
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(width * height * 3));
        GL11.glReadPixels((int)((int)(multiplierX * (float)this.renderPos.x)), (int)(this.mc.method_22683().method_4506() - height - (int)(multiplierY * (float)this.renderPos.y)), (int)width, (int)height, (int)6407, (int)5126, (FloatBuffer)buffer);
        Image img = new Image(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = buffer.get((x + y * width) * 3);
                float g = buffer.get((x + y * width) * 3 + 1);
                float b = buffer.get((x + y * width) * 3 + 2);
                int color = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
                img.setRGB(x, height - y - 1, color);
            }
        }
        Image rImg = new Image(size.x, size.y);
        rImg.draw(img, 0, 0, size.x, size.y);
        return rImg;
    }

    @Override
    public Mat4f getView() {
        return this.view;
    }

    @Override
    public Mat4f getProjection() {
        return this.proj;
    }

    public static class Renderer
    extends class_11239<State> {
        public Renderer(class_4597.class_4598 bufferSource) {
            super(bufferSource);
        }

        public Class<State> method_70903() {
            return State.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void renderToTexture(State pipState, class_4587 poseStack) {
            float partialTicks = 0.0f;
            class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
            Panel3d panel = pipState.impl().panel;
            GuiImpl gui = (GuiImpl)panel.getGui().getNativeGui();
            ViewportCamera cam = panel.getCamera();
            float pitch = (float)Math.asin(-cam.look.y);
            float yaw = cam.look.getYaw();
            float size = cam.camDist;
            Quaternionf quaternion = class_7833.field_40718.rotationDegrees(180.0f);
            Quaternionf quaternion1 = class_7833.field_40714.rotation(pitch);
            quaternion.mul((Quaternionfc)quaternion1);
            int i = class_310.method_1551().method_22683().method_4495();
            int j = (pipState.comp_4124() - pipState.comp_4122()) * i;
            int k = (pipState.comp_4125() - pipState.comp_4123()) * i;
            Matrix4f proj = new Matrix4f().setOrtho(0.0f, (float)j, (float)k, 0.0f, -1000.0f, 1000.0f);
            pipState.impl().proj = Mat4f.map(proj, Matrix4f::get);
            try {
                poseStack.method_22903();
                poseStack.method_34425((Matrix4fc)new Matrix4f().scaling(size, size, size));
                poseStack.method_22907((Quaternionfc)quaternion);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)((double)yaw + Math.PI)));
                poseStack.method_46416(-cam.position.x, -cam.position.y, -cam.position.z);
                pipState.impl().view = Mat4f.map(poseStack.method_23760().method_23761(), Matrix4f::get);
                int light = class_765.method_23687((int)15, (int)15);
                panel.render(new MatrixStack(), new VBuffers(rt -> new VBuffer(this.field_59933.method_73477((class_1921)rt.getNativeType()), light, class_4608.field_21444, poseStack)), partialTicks);
            }
            finally {
                poseStack.method_22909();
            }
        }

        protected float method_70907(int i, int j) {
            return (float)i / 2.0f;
        }

        protected String method_70906() {
            return "cpm:panel3d";
        }
    }

    public static final class State
    extends Record
    implements class_11256 {
        private final Panel3dImpl impl;
        private final int x0;
        private final int y0;
        private final int x1;
        private final int y1;
        private final class_8030 bounds;
        private final class_8030 scissorArea;

        public State(Panel3dImpl impl, int x0, int y0, int x1, int y1, class_8030 scissorArea) {
            this(impl, x0, y0, x1, y1, class_11256.method_71535((int)x0, (int)y0, (int)x1, (int)y1, (class_8030)scissorArea), scissorArea);
        }

        public State(Panel3dImpl impl, int x0, int y0, int x1, int y1, class_8030 bounds, class_8030 scissorArea) {
            this.impl = impl;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.bounds = bounds;
            this.scissorArea = scissorArea;
        }

        public float comp_4133() {
            return 1.0f;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{State.class, "impl;x0;y0;x1;y1;bounds;scissorArea", "impl", "x0", "y0", "x1", "y1", "bounds", "scissorArea"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{State.class, "impl;x0;y0;x1;y1;bounds;scissorArea", "impl", "x0", "y0", "x1", "y1", "bounds", "scissorArea"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{State.class, "impl;x0;y0;x1;y1;bounds;scissorArea", "impl", "x0", "y0", "x1", "y1", "bounds", "scissorArea"}, this, o);
        }

        public Panel3dImpl impl() {
            return this.impl;
        }

        public int comp_4122() {
            return this.x0;
        }

        public int comp_4123() {
            return this.y0;
        }

        public int comp_4124() {
            return this.x1;
        }

        public int comp_4125() {
            return this.y1;
        }

        public class_8030 comp_4274() {
            return this.bounds;
        }

        public class_8030 comp_4128() {
            return this.scissorArea;
        }
    }
}

