/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.CommonProxy;

public final class JadeFabricUtils {
    private JadeFabricUtils() {
    }

    public static List<ViewGroup<FluidView.Data>> fromFluidStorage(Storage<FluidVariant> storage) {
        int maxTanks;
        FluidCollectingResult result = JadeFabricUtils.fromFluidHandlerStream(storage);
        if (result.tanks == 0) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        int n = maxTanks = result.emptyTanks == 0 ? 5 : 4;
        if (result.tanks - result.emptyTanks <= maxTanks) {
            list.addAll(result.stream.toList());
        } else {
            result.stream.takeWhile(tag -> list.size() <= maxTanks).forEach(tuple1 -> {
                for (class_3545 tuple2 : list) {
                    if (!JadeFluidObject.isSameFluidSameComponents((JadeFluidObject)tuple1.method_15442(), (JadeFluidObject)tuple2.method_15442())) continue;
                    return;
                }
                list.add(tuple1);
            });
        }
        int remaining = result.tanks - result.emptyTanks - list.size();
        if (result.emptyTanks > 0) {
            list.add(new class_3545((Object)JadeFluidObject.empty(), (Object)result.emptyCapacity));
        }
        ViewGroup<FluidView.Data> group = new ViewGroup<FluidView.Data>(list.stream().map(tuple -> new FluidView.Data((JadeFluidObject)tuple.method_15442(), (long)((Long)tuple.method_15441()))).toList());
        if (remaining > 0) {
            group.getExtraData().method_10569("+", remaining);
        }
        return List.of(group);
    }

    public static FluidCollectingResult fromFluidHandlerStream(Storage<FluidVariant> storage) {
        FluidCollectingResult result = new FluidCollectingResult();
        storage.forEach($ -> {
            if ($.getCapacity() > 0L) {
                ++result.tanks;
                if ($.isResourceBlank()) {
                    ++result.emptyTanks;
                }
            }
        });
        result.stream = result.tanks == 0 ? Stream.empty() : Streams.stream((Iterator)storage.iterator()).map($ -> {
            long capacity = $.getCapacity();
            if (capacity <= 0L) {
                return null;
            }
            if ($.isResourceBlank()) {
                result.emptyCapacity = LongMath.saturatedAdd((long)result.emptyCapacity, (long)capacity);
                return null;
            }
            return new class_3545((Object)JadeFluidObject.of(((FluidVariant)$.getResource()).getFluid(), $.getAmount(), ((FluidVariant)$.getResource()).getComponents()), (Object)capacity);
        }).filter(Objects::nonNull);
        return result;
    }

    public static ItemIterator<? extends Storage<ItemVariant>> fromItemStorage(Storage<ItemVariant> storage, int fromIndex) {
        return JadeFabricUtils.fromItemStorage(storage, fromIndex, CommonProxy::findItemHandler);
    }

    public static ItemIterator<? extends Storage<ItemVariant>> fromItemStorage(Storage<ItemVariant> storage, int fromIndex, Function<Accessor<?>, @Nullable Storage<ItemVariant>> containerFinder) {
        if (storage instanceof SlottedStorage) {
            return new ItemIterator.SlottedItemIterator<SlottedStorage<ItemVariant>>(accessor -> {
                Object patt0$temp = containerFinder.apply((Accessor<?>)accessor);
                if (patt0$temp instanceof SlottedStorage) {
                    SlottedStorage slotted = (SlottedStorage)patt0$temp;
                    return slotted;
                }
                return null;
            }, fromIndex){

                @Override
                protected int getSlotCount(SlottedStorage<ItemVariant> container) {
                    return container.getSlotCount();
                }

                @Override
                protected class_1799 getItemInSlot(SlottedStorage<ItemVariant> container, int slot) {
                    SingleSlotStorage slotStorage = container.getSlot(slot);
                    return ((ItemVariant)slotStorage.getResource()).toStack((int)class_3532.method_53062((long)slotStorage.getAmount(), (long)0L, (long)Integer.MAX_VALUE));
                }

                @Override
                public long getVersion(SlottedStorage<ItemVariant> container) {
                    return container.getVersion();
                }
            };
        }
        return new ItemIterator.SlotlessItemIterator<Storage<ItemVariant>>(containerFinder, fromIndex){

            @Override
            protected Stream<class_1799> populateRaw(Storage<ItemVariant> container) {
                return Streams.stream((Iterator)container.nonEmptyIterator()).map($ -> ((ItemVariant)$.getResource()).toStack((int)class_3532.method_53062((long)$.getAmount(), (long)0L, (long)Integer.MAX_VALUE)));
            }

            @Override
            public long getVersion(Storage<ItemVariant> container) {
                return container.getVersion();
            }
        };
    }

    public static class FluidCollectingResult {
        public Stream<class_3545<JadeFluidObject, Long>> stream;
        public long emptyCapacity;
        public int tanks;
        public int emptyTanks;
    }
}

