/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_1055;
import net.minecraft.class_2960;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigManager;

@Mixin(value={class_7766.class})
public abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private class_2960 field_40549;
    @Unique
    List<class_7764> spriteContentsList;

    @Inject(method={"stitch"}, at={@At(value="HEAD")})
    public void stitch(List<class_7764> list, int i, Executor executor, CallbackInfoReturnable<class_7766.class_7767> cir) {
        if (this.field_40549.equals((Object)VersionUtil.getMcId("textures/atlas/particles.png"))) {
            this.spriteContentsList = list;
        }
    }

    @ModifyExpressionValue(method={"stitch"}, at={@At(value="NEW", args={"class=net/minecraft/client/renderer/texture/Stitcher"})})
    private class_1055<class_7764> registerWeatherParticleSprites(class_1055<class_7764> stitcher) {
        if (this.field_40549.equals((Object)VersionUtil.getMcId("textures/atlas/particles.png"))) {
            int i;
            int i2;
            class_1011 rainImage = null;
            class_1011 snowImage = null;
            try {
                rainImage = TextureUtil.loadTexture(VersionUtil.getMcId("textures/environment/rain.png"));
                snowImage = TextureUtil.loadTexture(VersionUtil.getMcId("textures/environment/snow.png"));
                TextureUtil.boostAlpha(rainImage, "rain");
                TextureUtil.boostAlpha(snowImage, "snow");
                if (ConfigManager.config.compat.waterTint) {
                    TextureUtil.desaturate(rainImage);
                }
            }
            catch (IOException e) {
                ParticleRain.LOGGER.error("Error loading weather textures: ", (Throwable)e);
            }
            for (i2 = 0; i2 < 4; ++i2) {
                stitcher.method_4553((class_1055.class_7769)TextureUtil.splitImage(rainImage, i2, "rain_"));
            }
            for (i2 = 0; i2 < 4; ++i2) {
                stitcher.method_4553((class_1055.class_7769)TextureUtil.splitImage(snowImage, i2, "snow_"));
            }
            int rippleResolution = TextureUtil.getRippleResolution(this.spriteContentsList);
            for (i = 0; i < 8; ++i) {
                stitcher.method_4553((class_1055.class_7769)TextureUtil.generateRipple(i, rippleResolution));
            }
            if (ConfigManager.config.compat.waterTint) {
                for (i = 0; i < 4; ++i) {
                    try {
                        stitcher.method_4553((class_1055.class_7769)VersionUtil.loadSplashSprite(i));
                        continue;
                    }
                    catch (IOException e) {
                        ParticleRain.LOGGER.error("Error loading splash particle {}: ", (Object)i, (Object)e);
                    }
                }
            }
        }
        return stitcher;
    }
}

