/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.fabric;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import ru.dimaskama.voicemessages.VoiceMessagesEvents;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.fabric.client.FabricVoiceRecordThread;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkC2S;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndC2S;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessageTargetsS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessagesConfigS2C;
import ru.dimaskama.voicemessages.networking.VoiceMessagesServerNetworking;
import ru.dimaskama.voicemessages.networking.VoiceMessagesVersionC2S;

public final class VoiceMessagesFabric
implements ModInitializer {
    public void onInitialize() {
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("voicemessages").orElseThrow();
        VoiceMessagesMod.init(modContainer.getMetadata().getVersion().toString(), new VoiceMessagesModService(this){

            @Override
            public boolean isModLoaded(String modId) {
                return FabricLoader.getInstance().isModLoaded(modId);
            }

            @Override
            public void sendToServer(class_8710 payload) {
                ClientPlayNetworking.send((class_8710)payload);
            }

            @Override
            public boolean canSendToServer(class_2960 payloadId) {
                return ClientPlayNetworking.canSend((class_2960)payloadId);
            }

            @Override
            public void sendToPlayer(class_3222 player, class_8710 payload) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            }

            @Override
            public VoiceMessagesModService.VoiceRecordThread createVoiceRecordThread(Predicate<short[]> frameConsumer, Consumer<IOException> onMicError) {
                return new FabricVoiceRecordThread(frameConsumer, onMicError);
            }

            @Override
            public boolean hasVoiceMessageSendPermission(class_3222 player) {
                return Permissions.check((class_1297)player, (String)"voicemessages.send", (int)0);
            }

            @Override
            public boolean hasVoiceMessageSendAllPermission(class_3222 player) {
                return Permissions.check((class_1297)player, (String)"voicemessages.send.all", (int)0);
            }

            @Override
            public boolean hasVoiceMessageSendTeamPermission(class_3222 player) {
                return Permissions.check((class_1297)player, (String)"voicemessages.send.team", (int)0);
            }

            @Override
            public boolean hasVoiceMessageSendPlayersPermission(class_3222 player) {
                return Permissions.check((class_1297)player, (String)"voicemessages.send.players", (int)0);
            }
        });
        if (VoiceMessagesMod.isActive()) {
            PayloadTypeRegistry.playS2C().register(VoiceMessagesConfigS2C.TYPE, VoiceMessagesConfigS2C.STREAM_CODEC);
            PayloadTypeRegistry.playS2C().register(VoiceMessageTargetsS2C.TYPE, VoiceMessageTargetsS2C.STREAM_CODEC);
            PayloadTypeRegistry.playS2C().register(VoiceMessageChunkS2C.TYPE, VoiceMessageChunkS2C.STREAM_CODEC);
            PayloadTypeRegistry.playS2C().register(VoiceMessageEndS2C.TYPE, VoiceMessageEndS2C.STREAM_CODEC);
            PayloadTypeRegistry.playC2S().register(VoiceMessagesVersionC2S.TYPE, VoiceMessagesVersionC2S.STREAM_CODEC);
            ServerPlayNetworking.registerGlobalReceiver(VoiceMessagesVersionC2S.TYPE, (payload, context) -> VoiceMessagesServerNetworking.onVoiceMessagesVersionReceived(context.player(), payload));
            PayloadTypeRegistry.playC2S().register(VoiceMessageChunkC2S.TYPE, VoiceMessageChunkC2S.STREAM_CODEC);
            ServerPlayNetworking.registerGlobalReceiver(VoiceMessageChunkC2S.TYPE, (payload, context) -> VoiceMessagesServerNetworking.onVoiceMessageChunkReceived(context.player(), payload));
            PayloadTypeRegistry.playC2S().register(VoiceMessageEndC2S.TYPE, VoiceMessageEndC2S.STREAM_CODEC);
            ServerPlayNetworking.registerGlobalReceiver(VoiceMessageEndC2S.TYPE, (payload, context) -> VoiceMessagesServerNetworking.onVoiceMessageEndReceived(context.player(), payload));
            ServerLifecycleEvents.SERVER_STARTED.register(VoiceMessagesEvents::onServerStarted);
            ServerTickEvents.END_SERVER_TICK.register(VoiceMessagesEvents::onServerTick);
            ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> VoiceMessagesServerNetworking.onPlayerDisconnected(server, handler.method_52404().id()));
        }
    }
}

