/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import ru.dimaskama.voicemessages.client.networking.VoiceMessagesClientNetworking;
import ru.dimaskama.voicemessages.client.screen.RecordVoiceMessageScreen;

public final class VoicemsgCommand<S> {
    public static final String ALIAS = "vmsg";
    private static final SimpleCommandExceptionType NO_PERMISSION_TO_SEND_TO_ALL = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"voicemessages.no_permission_to_send_to_all"));
    private static final DynamicCommandExceptionType UNKNOWN_TARGET = new DynamicCommandExceptionType(o -> class_2561.method_43469((String)"voicemessages.unknown_target", (Object[])new Object[]{o}));
    private final LiteralFactory<S> literal;
    private final ArgumentFactory<S> argument;

    public VoicemsgCommand(LiteralFactory<S> literal, ArgumentFactory<S> argument) {
        this.literal = literal;
        this.argument = argument;
    }

    public LiteralArgumentBuilder<S> createCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal.get("voicemsg").executes(this::executeWithoutTarget)).then(this.argument.get("target", StringArgumentType.greedyString()).suggests((context, builder) -> this.suggestTarget(builder)).executes(this::executeWithTarget));
    }

    private int executeWithoutTarget(CommandContext<S> context) throws CommandSyntaxException {
        if (!VoiceMessagesClientNetworking.getAvailableTargets().contains("all")) {
            throw NO_PERMISSION_TO_SEND_TO_ALL.create();
        }
        return VoicemsgCommand.startRecordingVoiceMessage("all");
    }

    private int executeWithTarget(CommandContext<S> context) throws CommandSyntaxException {
        String target = StringArgumentType.getString(context, (String)"target");
        if (!VoiceMessagesClientNetworking.getAvailableTargets().contains(target)) {
            throw UNKNOWN_TARGET.create((Object)target);
        }
        return VoicemsgCommand.startRecordingVoiceMessage(target);
    }

    private static int startRecordingVoiceMessage(String target) {
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        minecraft.method_63588(() -> minecraft.method_1507((class_437)new RecordVoiceMessageScreen((class_437)(screen instanceof class_408 ? screen : new class_408("", false)), 1, 15, target)));
        return 0;
    }

    private CompletableFuture<Suggestions> suggestTarget(SuggestionsBuilder builder) {
        String remain = builder.getRemainingLowerCase();
        VoiceMessagesClientNetworking.getAvailableTargets().stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(remain)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    @FunctionalInterface
    public static interface LiteralFactory<S> {
        public LiteralArgumentBuilder<S> get(String var1);
    }

    @FunctionalInterface
    public static interface ArgumentFactory<S> {
        public <T> RequiredArgumentBuilder<S, T> get(String var1, ArgumentType<T> var2);
    }
}

