/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client;

import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8030;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.client.Playback;
import ru.dimaskama.voicemessages.client.PlaybackManager;
import ru.dimaskama.voicemessages.client.render.PlaybackRenderer;

public class PlaybackPlayer {
    private static final int PLAY_BUTTON_SIDE = 10;
    private static final class_2960 PLAY_TEXTURE = VoiceMessagesMod.id("play");
    private static final class_2960 PAUSE_TEXTURE = VoiceMessagesMod.id("pause");
    private final PlaybackManager playbackManager;
    private final Playback playback;
    private final int backgroundColor;
    private final String totalDurationString;
    private class_8030 playButtonRectangle = new class_8030(0, 0, 0, 0);
    private class_8030 playbackTimeRectangle = new class_8030(0, 0, 0, 0);
    private class_8030 playbackRectangle = new class_8030(0, 0, 0, 0);
    private int alpha = 255;
    private int overlayColor = -1;

    public PlaybackPlayer(PlaybackManager playbackManager, Playback playback, int backgroundColor) {
        this.playbackManager = playbackManager;
        this.playback = playback;
        this.backgroundColor = backgroundColor;
        this.totalDurationString = "/" + PlaybackPlayer.formatTime(playback.getDurationMs());
    }

    public static String formatTime(int ms) {
        int s = ms / 1000;
        int m = s / 60;
        int sMod = s % 60;
        return String.format("%d:%02d", m, sMod);
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.overlayColor = class_9848.method_61330((int)alpha, (int)0xFFFFFF);
    }

    public PlaybackPlayer setRectangle(int x, int y, int width, int height) {
        this.playButtonRectangle = new class_8030(x, y + (height - 10 >> 1), 10, 10);
        int playbackX = x + Math.min(width, 13);
        this.playbackTimeRectangle = new class_8030(playbackX, y, x + width - playbackX, height);
        this.playbackRectangle = new class_8030(0, 0, 0, 0);
        return this;
    }

    public void transform(Matrix3x2f matrix) {
        this.playButtonRectangle = this.playButtonRectangle.method_65185(matrix);
        this.playbackTimeRectangle = this.playbackTimeRectangle.method_65185(matrix);
        this.playbackRectangle = this.playbackRectangle.method_65185(matrix);
    }

    public void render(class_332 guiGraphics) {
        this.renderPlayButton(guiGraphics);
        this.renderPlayback(guiGraphics);
    }

    private void renderPlayButton(class_332 guiGraphics) {
        class_2960 id = this.playback.isPlaying() ? PAUSE_TEXTURE : PLAY_TEXTURE;
        guiGraphics.method_52707(class_10799.field_56883, id, this.playButtonRectangle.method_49620(), this.playButtonRectangle.method_49618(), this.playButtonRectangle.comp_1196(), this.playButtonRectangle.comp_1197(), this.overlayColor);
    }

    private void renderPlayback(class_332 guiGraphics) {
        boolean renderTimeStr;
        String timeStr = this.getTimeString();
        class_327 font = class_310.method_1551().field_1772;
        int timeStrWidth = font.method_1727(timeStr);
        int playbackWidth = this.playbackTimeRectangle.comp_1196() - timeStrWidth - 5;
        boolean bl = renderTimeStr = playbackWidth >= 5;
        if (!renderTimeStr) {
            playbackWidth = this.playbackTimeRectangle.comp_1196();
        }
        if (playbackWidth >= 5) {
            int playbackX = this.playbackTimeRectangle.method_49620();
            int playbackY = this.playbackTimeRectangle.method_49618();
            int playbackHeight = this.playbackTimeRectangle.comp_1197();
            this.playbackRectangle = new class_8030(playbackX, playbackY, playbackWidth, playbackHeight);
            if ((this.backgroundColor & 0xFF000000) != 0) {
                guiGraphics.method_25294(playbackX - 1, playbackY - 1, playbackX + playbackWidth + 1, playbackY + playbackHeight + 1, -1);
                guiGraphics.method_25294(playbackX, playbackY, playbackX + playbackWidth, playbackY + playbackHeight, this.backgroundColor);
            }
            PlaybackRenderer.renderPlayback(guiGraphics, playbackX, playbackY, playbackWidth, playbackHeight, this.alpha, this.playback);
        } else {
            this.playbackRectangle = new class_8030(0, 0, 0, 0);
        }
        if (renderTimeStr) {
            guiGraphics.method_25303(font, timeStr, this.playbackTimeRectangle.method_49621() - timeStrWidth, this.playbackTimeRectangle.method_49618() + (this.playbackTimeRectangle.comp_1197() - 8 >> 1), this.overlayColor);
        }
    }

    private String getTimeString() {
        return PlaybackPlayer.formatTime(1000 * this.playback.getFramePosition() / 50) + this.totalDurationString;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            float delta;
            if (this.playbackRectangle.method_58137(mouseX, mouseY) && (delta = class_3532.method_37960((float)mouseX, (float)this.playbackRectangle.method_49620(), (float)this.playbackRectangle.method_49621())) >= 0.0f && delta <= 1.0f) {
                this.playback.setProgress(delta);
                this.playbackManager.play(this.playback);
                return true;
            }
            if (this.playButtonRectangle.method_58137(mouseX, mouseY)) {
                if (this.playback.isPlaying()) {
                    this.playbackManager.stopPlaying();
                } else {
                    this.playbackManager.play(this.playback);
                }
                return true;
            }
        }
        return false;
    }
}

