/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui;

import com.mojang.blaze3d.platform.Window;
import com.seibel.distanthorizons.core.config.gui.AbstractScreen;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class MinecraftScreen {
    public static Screen getScreen(Screen parent, AbstractScreen screen, String translationName) {
        return new ConfigScreenRenderer(parent, screen, translationName);
    }

    private static class ConfigScreenRenderer
    extends DhScreen {
        private final Screen parent;
        private ConfigListWidget configListWidget;
        private AbstractScreen screen;

        public static MutableComponent translate(String str, Object ... args) {
            return Component.translatable((String)str, (Object[])args);
        }

        protected ConfigScreenRenderer(Screen parent, AbstractScreen screen, String translationName) {
            super((Component)ConfigScreenRenderer.translate(translationName, new Object[0]));
            screen.minecraftWindow = Minecraft.getInstance().getWindow().handle();
            this.parent = parent;
            this.screen = screen;
        }

        protected void init() {
            super.init();
            Window mcWindow = this.minecraft.getWindow();
            this.screen.width = mcWindow.getWidth();
            this.screen.height = mcWindow.getHeight();
            this.screen.scaledWidth = this.width;
            this.screen.scaledHeight = this.height;
            this.screen.init();
            this.configListWidget = new ConfigListWidget(this.minecraft, this.width, this.height, 0, 0, 25);
            this.addWidget((GuiEventListener)this.configListWidget);
        }

        public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
            this.configListWidget.render(matrices, mouseX, mouseY, delta);
            this.screen.mouseX = mouseX;
            this.screen.mouseY = mouseY;
            this.screen.render(delta);
            super.render(matrices, mouseX, mouseY, delta);
        }

        public void resize(Minecraft mc, int width, int height) {
            super.resize(mc, width, height);
            Window mcWindow = this.minecraft.getWindow();
            this.screen.width = mcWindow.getWidth();
            this.screen.height = mcWindow.getHeight();
            this.screen.scaledWidth = this.width;
            this.screen.scaledHeight = this.height;
            this.screen.onResize();
        }

        public void tick() {
            super.tick();
            this.screen.tick();
            if (this.screen.close) {
                this.onClose();
            }
        }

        public void onClose() {
            this.screen.onClose();
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }

        public void onFilesDrop(@NotNull List<Path> files) {
            this.screen.onFilesDrop(files);
        }

        public boolean shouldCloseOnEsc() {
            return this.screen.shouldCloseOnEsc;
        }
    }

    public static class ConfigListWidget
    extends ContainerObjectSelectionList {
        public ConfigListWidget(Minecraft minecraftClient, int canvasWidth, int canvasHeight, int topMargin, int botMargin, int itemSpacing) {
            super(minecraftClient, canvasWidth, canvasHeight - (topMargin + botMargin), topMargin, itemSpacing);
            this.centerListVertically = false;
        }
    }
}

