/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.generic;

import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.api.enums.config.EDhApiLoggerMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiGenericObjectShaderProgram;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiRenderableBoxGroup;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeGenericObjectRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeGenericRenderCleanupEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeGenericRenderSetupEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.objects.math.DhApiVec3d;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBox;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBoxGroupShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.EPlatform;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLElementBuffer;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericRenderObjectFactory;
import com.seibel.distanthorizons.core.render.renderer.generic.RenderableBoxGroup;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.coreapi.DependencyInjection.OverrideInjector;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL33;
import org.lwjgl.system.MemoryUtil;

public class GenericObjectRenderer
implements IDhApiCustomRenderRegister {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final ConfigBasedSpamLogger SPAM_LOGGER = new ConfigBasedSpamLogger(LogManager.getLogger(GenericObjectRenderer.class), () -> EDhApiLoggerMode.LOG_ALL_TO_CHAT, 1);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final ISodiumAccessor SODIUM = ModAccessorInjector.INSTANCE.get(ISodiumAccessor.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private static final DhApiRenderableBoxGroupShading DEFAULT_SHADING = DhApiRenderableBoxGroupShading.getUnshaded();
    public static final boolean RENDER_DEBUG_OBJECTS = false;
    private boolean init = false;
    private IDhApiGenericObjectShaderProgram instancedShaderProgram;
    private IDhApiGenericObjectShaderProgram directShaderProgram;
    private GLVertexBuffer boxVertexBuffer;
    private GLElementBuffer boxIndexBuffer;
    private boolean instancedRenderingAvailable;
    private boolean vertexAttribDivisorSupported;
    private boolean instancedArraysSupported;
    private final ConcurrentHashMap<Long, RenderableBoxGroup> boxGroupById = new ConcurrentHashMap();
    private static final float[] BOX_VERTICES = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final int[] BOX_INDICES = new int[]{2, 1, 0, 0, 3, 2, 6, 5, 4, 4, 7, 6, 10, 9, 8, 8, 11, 10, 14, 13, 12, 12, 15, 14, 18, 17, 16, 16, 19, 18, 20, 21, 22, 22, 23, 20};

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.vertexAttribDivisorSupported = GLProxy.getInstance().vertexAttribDivisorSupported;
        this.instancedArraysSupported = GLProxy.getInstance().instancedArraysSupported;
        boolean bl = this.instancedRenderingAvailable = this.vertexAttribDivisorSupported || this.instancedArraysSupported;
        if (!this.instancedRenderingAvailable) {
            LOGGER.warn("Instanced rendering not supported by this GPU, falling back to direct rendering. Generic object rendering will be slow and some effects may be disabled.");
        } else {
            boolean isMac;
            boolean bl2 = isMac = EPlatform.get() == EPlatform.MACOS;
            if (isMac && SODIUM != null) {
                LOGGER.warn("There have been reports of instanced rendering causing crashes on macOS when Sodium is present. Instanced rendering can be disabled via the DH config.");
            }
        }
        this.instancedShaderProgram = new GenericObjectShaderProgram(true);
        this.directShaderProgram = new GenericObjectShaderProgram(false);
        this.createBuffers();
    }

    private void createBuffers() {
        ByteBuffer boxVerticesBuffer = MemoryUtil.memAlloc((int)(BOX_VERTICES.length * 4));
        boxVerticesBuffer.asFloatBuffer().put(BOX_VERTICES);
        boxVerticesBuffer.rewind();
        this.boxVertexBuffer = new GLVertexBuffer(false);
        this.boxVertexBuffer.bind();
        this.boxVertexBuffer.uploadBuffer(boxVerticesBuffer, 8, EDhApiGpuUploadMethod.DATA, BOX_VERTICES.length * 4);
        MemoryUtil.memFree((Buffer)boxVerticesBuffer);
        ByteBuffer solidIndexBuffer = MemoryUtil.memAlloc((int)(BOX_INDICES.length * 4));
        solidIndexBuffer.asIntBuffer().put(BOX_INDICES);
        solidIndexBuffer.rewind();
        this.boxIndexBuffer = new GLElementBuffer(false);
        this.boxIndexBuffer.uploadBuffer(solidIndexBuffer, EDhApiGpuUploadMethod.DATA, BOX_INDICES.length * 4, 35044);
        this.boxIndexBuffer.bind();
        MemoryUtil.memFree((Buffer)solidIndexBuffer);
    }

    private void addGenericDebugObjects() {
        GenericRenderObjectFactory factory = GenericRenderObjectFactory.INSTANCE;
        IDhApiRenderableBoxGroup singleGiantBoxGroup = factory.createForSingleBox("DistantHorizons:CyanChunkBox", new DhApiRenderableBox(new DhApiVec3d(0.0, 0.0, 0.0), new DhApiVec3d(16.0, 190.0, 16.0), new Color(Color.CYAN.getRed(), Color.CYAN.getGreen(), Color.CYAN.getBlue(), 125), EDhApiBlockMaterial.WATER));
        singleGiantBoxGroup.setSkyLight(15);
        singleGiantBoxGroup.setBlockLight(15);
        this.add(singleGiantBoxGroup);
        IDhApiRenderableBoxGroup singleTallBoxGroup = factory.createForSingleBox("DistantHorizons:GreenBeacon", new DhApiRenderableBox(new DhApiVec3d(16.0, 0.0, 31.0), new DhApiVec3d(17.0, 2000.0, 32.0), new Color(Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue(), 125), EDhApiBlockMaterial.ILLUMINATED));
        singleTallBoxGroup.setSkyLight(15);
        singleTallBoxGroup.setBlockLight(15);
        this.add(singleTallBoxGroup);
        ArrayList<DhApiRenderableBox> absBoxList = new ArrayList<DhApiRenderableBox>();
        for (int i = 0; i < 18; ++i) {
            absBoxList.add(new DhApiRenderableBox(new DhApiVec3d(i, 150 + i, 24.0), new DhApiVec3d(1 + i, 151 + i, 25.0), new Color(Color.ORANGE.getRed(), Color.ORANGE.getGreen(), Color.ORANGE.getBlue()), EDhApiBlockMaterial.LAVA));
        }
        IDhApiRenderableBoxGroup absolutePosBoxGroup = factory.createAbsolutePositionedGroup("DistantHorizons:OrangeStairs", absBoxList);
        this.add(absolutePosBoxGroup);
        ArrayList<DhApiRenderableBox> relBoxList = new ArrayList<DhApiRenderableBox>();
        for (int i = 0; i < 8; i += 2) {
            relBoxList.add(new DhApiRenderableBox(new DhApiVec3d(0.0, i, 0.0), new DhApiVec3d(1.0, 1 + i, 1.0), new Color(Color.MAGENTA.getRed(), Color.MAGENTA.getGreen(), Color.MAGENTA.getBlue()), EDhApiBlockMaterial.METAL));
        }
        IDhApiRenderableBoxGroup relativePosBoxGroup = factory.createRelativePositionedGroup("DistantHorizons:MovingMagentaGroup", new DhApiVec3d(24.0, 140.0, 24.0), relBoxList);
        relativePosBoxGroup.setPreRenderFunc(event -> {
            DhApiVec3d pos = relativePosBoxGroup.getOriginBlockPos();
            pos.x += (double)(event.partialTicks / 2.0f);
            pos.x %= 32.0;
            relativePosBoxGroup.setOriginBlockPos(pos);
        });
        this.add(relativePosBoxGroup);
        ArrayList<DhApiRenderableBox> massRelBoxList = new ArrayList<DhApiRenderableBox>();
        for (int x = 0; x < 100; x += 2) {
            for (int z = 0; z < 100; z += 2) {
                massRelBoxList.add(new DhApiRenderableBox(new DhApiVec3d(-x, 0.0, -z), new DhApiVec3d(1 - x, 1.0, 1 - z), new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue()), EDhApiBlockMaterial.TERRACOTTA));
            }
        }
        IDhApiRenderableBoxGroup massRelativePosBoxGroup = factory.createRelativePositionedGroup("DistantHorizons:MassRedGroup", new DhApiVec3d(-25.0, 140.0, 0.0), massRelBoxList);
        massRelativePosBoxGroup.setPreRenderFunc(event -> {
            DhApiVec3d blockPos = massRelativePosBoxGroup.getOriginBlockPos();
            blockPos.y += (double)(event.partialTicks / 4.0f);
            if (blockPos.y > 150.0) {
                blockPos.y = 140.0;
                Color newColor = ((DhApiRenderableBox)massRelativePosBoxGroup.get((int)0)).color == Color.RED ? Color.RED.darker() : Color.RED;
                massRelativePosBoxGroup.forEach(box -> {
                    box.color = newColor;
                });
                massRelativePosBoxGroup.triggerBoxChange();
            }
            massRelativePosBoxGroup.setOriginBlockPos(blockPos);
        });
        this.add(massRelativePosBoxGroup);
    }

    @Override
    public void add(IDhApiRenderableBoxGroup iBoxGroup) throws IllegalArgumentException {
        if (!(iBoxGroup instanceof RenderableBoxGroup)) {
            throw new IllegalArgumentException("Box group must be of type [" + RenderableBoxGroup.class.getSimpleName() + "], type received: [" + (iBoxGroup != null ? iBoxGroup.getClass() : "NULL") + "].");
        }
        RenderableBoxGroup boxGroup = (RenderableBoxGroup)iBoxGroup;
        long id = boxGroup.getId();
        if (this.boxGroupById.containsKey(id)) {
            throw new IllegalArgumentException("A box group with the ID [" + id + "] is already present.");
        }
        this.boxGroupById.put(id, boxGroup);
    }

    @Override
    public IDhApiRenderableBoxGroup remove(long id) {
        return this.boxGroupById.remove(id);
    }

    public void clear() {
        this.boxGroupById.clear();
    }

    public void render(DhApiRenderParam renderEventParam, IProfilerWrapper profiler, boolean renderingWithSsao) {
        profiler.push("setup");
        this.init();
        boolean useInstancedRendering = this.instancedRenderingAvailable && Config.Client.Advanced.Graphics.GenericRendering.enableInstancedRendering.get() != false;
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeGenericRenderSetupEvent.class, renderEventParam);
        boolean renderWireframe = Config.Client.Advanced.Debugging.renderWireframe.get();
        if (renderWireframe) {
            GL32.glPolygonMode((int)1032, (int)6913);
            GLMC.disableFaceCulling();
        } else {
            GL32.glPolygonMode((int)1032, (int)6914);
            GLMC.enableFaceCulling();
        }
        GLMC.enableBlend();
        GL32.glBlendEquation((int)32774);
        GLMC.glBlendFuncSeparate(770, 771, 1, 771);
        IDhApiGenericObjectShaderProgram shaderProgram = useInstancedRendering ? this.instancedShaderProgram : this.directShaderProgram;
        IDhApiGenericObjectShaderProgram shaderProgramOverride = OverrideInjector.INSTANCE.get(IDhApiGenericObjectShaderProgram.class);
        if (shaderProgramOverride != null && shaderProgram.overrideThisFrame()) {
            shaderProgram = shaderProgramOverride;
        }
        shaderProgram.bind(renderEventParam);
        shaderProgram.bindVertexBuffer(this.boxVertexBuffer.getId());
        this.boxIndexBuffer.bind();
        Vec3d camPos = MC_RENDER.getCameraExactPosition();
        Collection<RenderableBoxGroup> boxList = this.boxGroupById.values();
        for (RenderableBoxGroup boxGroup : boxList) {
            boolean cancelRendering;
            if (boxGroup == null || boxGroup.ssaoEnabled != renderingWithSsao) continue;
            profiler.popPush("render prep");
            boxGroup.preRender(renderEventParam);
            if (!boxGroup.active || (cancelRendering = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeGenericObjectRenderEvent.class, new DhApiBeforeGenericObjectRenderEvent.EventParam(renderEventParam, boxGroup)))) continue;
            profiler.popPush("rendering");
            profiler.push(boxGroup.getResourceLocationNamespace());
            profiler.push(boxGroup.getResourceLocationPath());
            if (useInstancedRendering) {
                this.renderBoxGroupInstanced(shaderProgram, renderEventParam, boxGroup, camPos, profiler);
            } else {
                this.renderBoxGroupDirect(shaderProgram, renderEventParam, boxGroup, camPos);
            }
            profiler.pop();
            profiler.pop();
            boxGroup.postRender(renderEventParam);
        }
        profiler.popPush("cleanup");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeGenericRenderCleanupEvent.class, renderEventParam);
        if (renderWireframe) {
            GL32.glPolygonMode((int)1032, (int)6914);
            GLMC.enableFaceCulling();
        }
        shaderProgram.unbind();
        profiler.pop();
    }

    private void renderBoxGroupInstanced(IDhApiGenericObjectShaderProgram shaderProgram, DhApiRenderParam renderEventParam, RenderableBoxGroup boxGroup, Vec3d camPos, IProfilerWrapper profiler) {
        profiler.push("vertex setup");
        boxGroup.updateVertexAttributeData();
        DhApiRenderableBoxGroupShading shading = boxGroup.shading;
        if (shading == null) {
            shading = DEFAULT_SHADING;
        }
        shaderProgram.fillIndirectUniformData(renderEventParam, shading, boxGroup, camPos);
        profiler.popPush("binding");
        GL32.glBindBuffer((int)34962, (int)boxGroup.instanceColorVbo);
        GL32.glEnableVertexAttribArray((int)1);
        GL32.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)16, (long)0L);
        this.vertexAttribDivisor(1, 1);
        GL32.glBindBuffer((int)34962, (int)boxGroup.instanceScaleVbo);
        GL32.glEnableVertexAttribArray((int)2);
        this.vertexAttribDivisor(2, 1);
        GL32.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)12, (long)0L);
        GL32.glBindBuffer((int)34962, (int)boxGroup.instanceChunkPosVbo);
        GL32.glEnableVertexAttribArray((int)3);
        this.vertexAttribDivisor(3, 1);
        GL32.glVertexAttribIPointer((int)3, (int)3, (int)5124, (int)12, (long)0L);
        GL32.glBindBuffer((int)34962, (int)boxGroup.instanceSubChunkPosVbo);
        GL32.glEnableVertexAttribArray((int)4);
        this.vertexAttribDivisor(4, 1);
        GL32.glVertexAttribPointer((int)4, (int)3, (int)5126, (boolean)false, (int)12, (long)0L);
        GL32.glBindBuffer((int)34962, (int)boxGroup.instanceMaterialVbo);
        GL32.glEnableVertexAttribArray((int)5);
        this.vertexAttribDivisor(5, 1);
        GL32.glVertexAttribIPointer((int)5, (int)1, (int)5120, (int)1, (long)0L);
        profiler.popPush("render");
        if (boxGroup.uploadedBoxCount > 0) {
            GL32.glDrawElementsInstanced((int)4, (int)BOX_INDICES.length, (int)5125, (long)0L, (int)boxGroup.uploadedBoxCount);
        }
        profiler.popPush("cleanup");
        GL32.glDisableVertexAttribArray((int)1);
        GL32.glDisableVertexAttribArray((int)2);
        GL32.glDisableVertexAttribArray((int)3);
        GL32.glDisableVertexAttribArray((int)4);
        GL32.glDisableVertexAttribArray((int)5);
        profiler.pop();
    }

    private void vertexAttribDivisor(int index, int divisor) {
        if (this.vertexAttribDivisorSupported) {
            GL33.glVertexAttribDivisor((int)index, (int)divisor);
        } else if (this.instancedArraysSupported) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)index, (int)divisor);
        } else {
            throw new IllegalStateException("Instanced rendering isn't supported by this machine. Direct rendering should have been used instead.");
        }
    }

    private void renderBoxGroupDirect(IDhApiGenericObjectShaderProgram shaderProgram, DhApiRenderParam renderEventParam, RenderableBoxGroup boxGroup, Vec3d camPos) {
        DhApiRenderableBoxGroupShading shading = boxGroup.shading;
        if (shading == null) {
            shading = DhApiRenderableBoxGroupShading.getUnshaded();
        }
        shaderProgram.fillSharedDirectUniformData(renderEventParam, shading, boxGroup, camPos);
        for (int i = 0; i < boxGroup.size(); ++i) {
            try {
                DhApiRenderableBox box = boxGroup.get(i);
                if (box == null) continue;
                this.renderBox(shaderProgram, renderEventParam, boxGroup, box, camPos);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
        }
    }

    private void renderBox(IDhApiGenericObjectShaderProgram shaderProgram, DhApiRenderParam renderEventParam, RenderableBoxGroup boxGroup, DhApiRenderableBox box, Vec3d camPos) {
        shaderProgram.fillDirectUniformData(renderEventParam, boxGroup, box, camPos);
        GL32.glDrawElements((int)4, (int)BOX_INDICES.length, (int)5125, (long)0L);
    }

    public boolean getInstancedRenderingAvailable() throws IllegalStateException {
        if (!this.init) {
            throw new IllegalStateException("GL initialization hasn't been completed.");
        }
        return this.instancedRenderingAvailable;
    }

    public String getVboRenderDebugMenuString() {
        int totalGroupCount = this.boxGroupById.size();
        int totalBoxCount = 0;
        int activeGroupCount = 0;
        int activeBoxCount = 0;
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.boxGroupById.keySet()).iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            RenderableBoxGroup renderGroup = this.boxGroupById.get(key);
            if (renderGroup.active) {
                ++activeGroupCount;
                activeBoxCount += renderGroup.size();
            }
            totalBoxCount += renderGroup.size();
        }
        return "Generic Obj #: " + F3Screen.NUMBER_FORMAT.format(activeGroupCount) + "/" + F3Screen.NUMBER_FORMAT.format(totalGroupCount) + ", Cube #: " + F3Screen.NUMBER_FORMAT.format(activeBoxCount) + "/" + F3Screen.NUMBER_FORMAT.format(totalBoxCount);
    }
}

