/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular;

import com.leclowndu93150.particular.Constants;
import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.mixin.AccessorBiome;
import com.leclowndu93150.particular.utils.CascadeData;
import com.leclowndu93150.particular.utils.LeafColorUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_703;
import net.minecraft.class_7923;

public class CommonClass {
    public static class_2960 currentDimension;
    public static ConcurrentHashMap<class_2338, CascadeData> cascades;
    private static float fireflyFrequency;
    private static Map<class_2248, LeafData> leavesData;

    public static void init() {
        Constants.LOG.info("I am quite particular about the effects I choose to add :3");
    }

    public static void clientSetup() {
        for (class_2248 block : class_7923.field_41175) {
            boolean isLeafBlock;
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            if (leavesData.containsKey(block) || !(isLeafBlock = block instanceof class_2397 || id.method_12832().contains("leaves") || id.method_12832().contains("leaf"))) continue;
            class_2400 particle = Particles.OAK_LEAF();
            if (id.method_12832().contains("spruce") || id.method_12832().contains("pine") || id.method_12832().contains("fir") || id.method_12832().contains("conifer")) {
                particle = Particles.SPRUCE_LEAF();
            } else if (id.method_12832().contains("birch")) {
                particle = Particles.BIRCH_LEAF();
            } else if (id.method_12832().contains("jungle")) {
                particle = Particles.JUNGLE_LEAF();
            } else if (id.method_12832().contains("acacia")) {
                particle = Particles.ACACIA_LEAF();
            } else if (id.method_12832().contains("dark_oak")) {
                particle = Particles.DARK_OAK_LEAF();
            } else if (id.method_12832().contains("mangrove")) {
                particle = Particles.MANGROVE_LEAF();
            }
            LeafData leafData = new LeafData((class_2394)particle);
            leavesData.put(block, leafData);
        }
    }

    public static Color extractLeafColor(class_1937 world, class_2338 pos, class_2248 block) {
        class_2680 state = block.method_9564();
        try {
            if (world.method_8320(pos).method_26204() == block) {
                state = world.method_8320(pos);
            }
            double[] colorValues = LeafColorUtil.getBlockTextureColor(state, world, pos);
            return LeafColorUtil.getColorFromValues(colorValues);
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to extract leaf color", (Throwable)e);
            return new Color(class_1163.method_4966((class_1920)world, (class_2338)pos));
        }
    }

    public static void registerLeafData(class_2248 block, LeafData leafData) {
        leavesData.put(block, leafData);
    }

    public static void registerLeafData(class_2960 id, LeafData leafData) {
        class_7923.field_41175.method_17966(id).ifPresent(block -> leavesData.put((class_2248)block, leafData));
    }

    public static LeafData getLeafData(class_2248 block) {
        return leavesData.getOrDefault(block, new LeafData((class_2394)Particles.OAK_LEAF()));
    }

    public static void updateCascade(class_1937 world, class_2338 pos, class_3610 state) {
        boolean shouldHaveCascade;
        class_2338 immutablePos = pos.method_10062();
        if (cascades.containsKey(immutablePos)) {
            return;
        }
        boolean bl = shouldHaveCascade = state.method_39360((class_3611)class_3612.field_15910) && world.method_8316(pos.method_10084()).method_39360((class_3611)class_3612.field_15909) && world.method_8316(pos.method_10074()).method_39360((class_3611)class_3612.field_15910);
        if (shouldHaveCascade) {
            int strength = 0;
            if (world.method_8316(pos.method_10095()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10078()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10072()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10067()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (strength > 0) {
                boolean isEncased;
                boolean bl2 = isEncased = !world.method_8320(pos.method_10084().method_10095()).method_26215() && !world.method_8320(pos.method_10084().method_10078()).method_26215() && !world.method_8320(pos.method_10084().method_10072()).method_26215() && !world.method_8320(pos.method_10084().method_10067()).method_26215();
                if (!isEncased) {
                    cascades.put(immutablePos, new CascadeData(strength, world.method_8510() - 101L));
                }
            }
        }
    }

    public static void spawnBubble(class_2394 particle, class_1937 world, class_2338 pos) {
        double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * 0.5;
        double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
        double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * 0.5;
        world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnFirefly(class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43058() > (double)fireflyFrequency) {
            return;
        }
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        float downfall = ((AccessorBiome)biome).getWeather().comp_846();
        if ((!world.method_8419() || ((Boolean)ParticularConfig.COMMON.fireflyCanSpawnInRain.get()).booleanValue()) && random.method_43048(30 - (int)(10.0f * downfall)) == 0) {
            long timeOfDay = world.method_8532() % 24000L;
            float temp = biome.method_8712();
            if (timeOfDay >= (long)((Integer)ParticularConfig.COMMON.fireflyStartTime.get()).intValue() && timeOfDay <= (long)((Integer)ParticularConfig.COMMON.fireflyEndTime.get()).intValue() && (double)temp >= (Double)ParticularConfig.COMMON.fireflyMinTemp.get() && (double)temp <= (Double)ParticularConfig.COMMON.fireflyMaxTemp.get()) {
                world.method_8406((class_2394)Particles.FIREFLY(), (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnDoubleBubbles(class_2394 particle, class_1937 world, class_2338 pos, class_2680 state) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
            case field_11043: {
                xLen = true;
                if (chestType != class_2745.field_12571) break;
                xOffset = -1;
                break;
            }
            case field_11035: {
                xLen = true;
                if (chestType != class_2745.field_12574) break;
                xOffset = -1;
                break;
            }
            case field_11034: {
                zLen = true;
                if (chestType != class_2745.field_12571) break;
                zOffset = -1;
                break;
            }
            case field_11039: {
                zLen = true;
                if (chestType != class_2745.field_12574) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
            double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)zLen) + (double)zOffset;
            world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnChestBubbles(class_2394 particle, class_1937 world, class_2338 pos) {
        for (int i = 0; i < 10; ++i) {
            CommonClass.spawnBubble(particle, world, pos);
        }
    }

    public static void spawnDoubleChestBubbles(class_2394 particle, class_1937 world, class_2338 pos, class_2680 state) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
            case field_11043: {
                xLen = true;
                if (chestType != class_2745.field_12571) break;
                xOffset = -1;
                break;
            }
            case field_11035: {
                xLen = true;
                if (chestType != class_2745.field_12574) break;
                xOffset = -1;
                break;
            }
            case field_11034: {
                zLen = true;
                if (chestType != class_2745.field_12571) break;
                zOffset = -1;
                break;
            }
            case field_11039: {
                zLen = true;
                if (chestType != class_2745.field_12574) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 20; ++i) {
            double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
            double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)zLen) + (double)zOffset;
            world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void onClientTick(class_1937 world) {
        if (world == null) {
            return;
        }
        class_5819 random = world.field_9229;
        if (world.method_8532() % 24000L == (long)((Integer)ParticularConfig.COMMON.fireflyStartTime.get()).intValue()) {
            List dailyRandomList = (List)ParticularConfig.COMMON.fireflyDailyRandom.get();
            fireflyFrequency = ((Double)dailyRandomList.get(random.method_43048(dailyRandomList.size()))).floatValue();
        }
        if (!ParticularConfig.cascades()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        int renderDistance = (Integer)mc.field_1690.method_42503().method_41753();
        class_2338 playerPos = mc.field_1724.method_24515();
        long currentTime = world.method_8510();
        cascades.entrySet().removeIf(entry -> {
            class_2338 pos = (class_2338)entry.getKey();
            CascadeData cascadeData = (CascadeData)entry.getValue();
            int chunkDistance = Math.max(Math.abs((pos.method_10263() >> 4) - (playerPos.method_10263() >> 4)), Math.abs((pos.method_10260() >> 4) - (playerPos.method_10260() >> 4)));
            if (chunkDistance > renderDistance + 2) {
                return true;
            }
            if (currentTime - cascadeData.createdTime > 100L) {
                if (world.method_8316(pos).method_39360((class_3611)class_3612.field_15910) && world.method_8316(pos.method_10084()).method_39360((class_3611)class_3612.field_15909) && world.method_8316(pos.method_10074()).method_39360((class_3611)class_3612.field_15910)) {
                    int strength = 0;
                    if (world.method_8316(pos.method_10095()).method_39360((class_3611)class_3612.field_15910)) {
                        ++strength;
                    }
                    if (world.method_8316(pos.method_10078()).method_39360((class_3611)class_3612.field_15910)) {
                        ++strength;
                    }
                    if (world.method_8316(pos.method_10072()).method_39360((class_3611)class_3612.field_15910)) {
                        ++strength;
                    }
                    if (world.method_8316(pos.method_10067()).method_39360((class_3611)class_3612.field_15910)) {
                        ++strength;
                    }
                    if (strength > 0) {
                        boolean isEncased;
                        boolean bl = isEncased = !world.method_8320(pos.method_10084().method_10095()).method_26215() && !world.method_8320(pos.method_10084().method_10078()).method_26215() && !world.method_8320(pos.method_10084().method_10072()).method_26215() && !world.method_8320(pos.method_10084().method_10067()).method_26215();
                        if (!isEncased) {
                            cascades.put(pos, new CascadeData(strength, currentTime));
                            return false;
                        }
                    }
                }
                return true;
            }
            if (!(world.method_8316(pos).method_39360((class_3611)class_3612.field_15910) && world.method_8316(pos.method_10084()).method_39360((class_3611)class_3612.field_15909) && world.method_8316(pos.method_10074()).method_39360((class_3611)class_3612.field_15910))) {
                return true;
            }
            float height = world.method_8316(pos.method_10084()).method_20785();
            double x = pos.method_10263();
            double y = (double)pos.method_10264() + random.method_43058() * (double)height + 1.0;
            double z = pos.method_10260();
            if (random.method_43056()) {
                x += random.method_43058();
                z += (double)random.method_39332(0, 1);
            } else {
                x += (double)random.method_39332(0, 1);
                z += random.method_43058();
            }
            class_703 cascade = mc.field_1713.method_3056((class_2394)Particles.CASCADE(), x, y, z, 0.0, 0.0, 0.0);
            if (cascade != null) {
                float size = (float)cascadeData.strength / 4.0f * height;
                cascade.method_3087(1.0f - (1.0f - size) / 2.0f);
            }
            return false;
        });
    }

    public static void onChunkLoad(class_1937 world) {
        if (!ParticularConfig.cascades() || !world.method_8608()) {
            return;
        }
        class_2960 newDimension = world.method_8597().comp_655();
        if (currentDimension != null && !newDimension.equals((Object)currentDimension)) {
            Constants.LOG.debug("Dimension changed from {} to {}, clearing cascades", (Object)currentDimension, (Object)newDimension);
            cascades.clear();
        }
        currentDimension = newDimension;
    }

    public static void onChunkUnload(class_1937 world, int minX, int maxX, int minZ, int maxZ) {
        if (!ParticularConfig.cascades() || !world.method_8608()) {
            return;
        }
        cascades.entrySet().removeIf(entry -> {
            class_2338 pos = (class_2338)entry.getKey();
            return pos.method_10263() >= minX && pos.method_10263() <= maxX && pos.method_10260() >= minZ && pos.method_10260() <= maxZ;
        });
    }

    public static void onLevelUnload(class_1937 world) {
        if (world.method_8608()) {
            cascades.clear();
        }
    }

    public static void cleanupInvalidCascades(class_1937 world) {
        if (!ParticularConfig.cascades()) {
            cascades.clear();
            return;
        }
        long currentTime = world.method_8510();
        cascades.entrySet().removeIf(entry -> {
            class_2338 pos = (class_2338)entry.getKey();
            CascadeData cascadeData = (CascadeData)entry.getValue();
            if (!world.method_22340(pos)) {
                return true;
            }
            if (currentTime - cascadeData.createdTime > 100L) {
                return true;
            }
            class_3610 currentState = world.method_8316(pos);
            class_3610 aboveState = world.method_8316(pos.method_10084());
            class_3610 belowState = world.method_8316(pos.method_10074());
            boolean isValid = currentState.method_39360((class_3611)class_3612.field_15910) && aboveState.method_39360((class_3611)class_3612.field_15909) && belowState.method_39360((class_3611)class_3612.field_15910);
            return !isValid;
        });
    }

    static {
        cascades = new ConcurrentHashMap();
        fireflyFrequency = 1.0f;
        leavesData = new HashMap<class_2248, LeafData>();
    }

    public static class LeafData {
        private final class_2394 particle;
        private final BiFunction<class_1937, class_2338, Color> colorBiFunc;

        public LeafData(class_2394 particle, BiFunction<class_1937, class_2338, Color> colorBiFunc) {
            this.particle = particle;
            this.colorBiFunc = colorBiFunc;
        }

        public LeafData(class_2394 particle, Color color) {
            this(particle, (class_1937 world, class_2338 pos) -> color);
        }

        public LeafData(class_2394 particle) {
            this(particle, (class_1937 world, class_2338 pos) -> {
                class_2248 block = world.method_8320(pos).method_26204();
                return CommonClass.extractLeafColor(world, pos, block);
            });
        }

        public class_2394 getParticle() {
            return this.particle;
        }

        public Color getColor(class_1937 world, class_2338 pos) {
            return this.colorBiFunc.apply(world, pos);
        }
    }
}

