/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5481;

public abstract class VoiceChatScreenBase
extends class_437 {
    public static final int FONT_COLOR = -12566464;
    protected List<HoverArea> hoverAreas;
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;

    protected VoiceChatScreenBase(class_2561 title, int xSize, int ySize) {
        super(title);
        this.xSize = xSize;
        this.ySize = ySize;
        this.hoverAreas = new ArrayList<HoverArea>();
    }

    protected void method_25426() {
        this.method_37067();
        super.method_25426();
        this.guiLeft = (this.field_22789 - this.xSize) / 2;
        this.guiTop = (this.field_22790 - this.ySize) / 2;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isIngame()) {
            this.method_52752(guiGraphics);
        } else {
            this.method_57728(guiGraphics, delta);
            this.method_57734(guiGraphics);
        }
        this.method_25420(guiGraphics, mouseX, mouseY, delta);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.renderForeground(guiGraphics, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public void renderForeground(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    protected boolean isIngame() {
        return this.field_22787.field_1687 != null;
    }

    protected int getFontColor() {
        return this.isIngame() ? -12566464 : class_124.field_1068.method_532();
    }

    public void drawHoverAreas(class_332 guiGraphics, int mouseX, int mouseY) {
        for (HoverArea hoverArea : this.hoverAreas) {
            if (hoverArea.tooltip == null || !hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
            guiGraphics.method_51447(this.field_22787.field_1772, hoverArea.tooltip.get(), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    public static class HoverArea {
        private final int posX;
        private final int posY;
        private final int width;
        private final int height;
        @Nullable
        private final Supplier<List<class_5481>> tooltip;

        public HoverArea(int posX, int posY, int width, int height) {
            this(posX, posY, width, height, null);
        }

        public HoverArea(int posX, int posY, int width, int height, Supplier<List<class_5481>> tooltip) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.tooltip = tooltip;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Nullable
        public Supplier<List<class_5481>> getTooltip() {
            return this.tooltip;
        }

        public boolean isHovered(int guiLeft, int guiTop, int mouseX, int mouseY) {
            return mouseX >= guiLeft + this.posX && mouseX < guiLeft + this.posX + this.width && mouseY >= guiTop + this.posY && mouseY < guiTop + this.posY + this.height;
        }
    }
}

